package gov.va.med.mhv.common.api.enumeration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum ReportTypeEnum {
	PDF("PDF"), TXT("TXT"), PDFDL("PDFDL"), TXTDL("TXTDL"), XHTML("XHTML"), VIEWTXT("VIEWTXT");

	private String type;

	private ReportTypeEnum(String type) {
		this.type = type;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public static List<ReportTypeEnum> toList() {
		return Arrays.asList(ReportTypeEnum.values());
	}

	public static ReportTypeEnum valueOfByType(String type) {
		for (ReportTypeEnum e : ReportTypeEnum.values()) {
			if (e.getType().equals(type)) {
				return e;
			}
		}
		return null;
	}

	public static List<String> toTypeList() {
		List<String> typeList = new ArrayList<String>();
		for (ReportTypeEnum ft : Arrays.asList(ReportTypeEnum.values())) {
			typeList.add(ft.getType());
		}
		return typeList;
	}

	static public boolean isPDF(ReportTypeEnum reportType) {
		return reportType == PDF;
	}

	static public boolean isTXT(ReportTypeEnum reportType) {
		return reportType == TXT;
	}

	static public boolean isXHTML(ReportTypeEnum reportType) {
		return reportType == XHTML;
	}
	
	static public boolean isPDFDL(ReportTypeEnum reportType) {
		return reportType == PDFDL;
	}

	static public boolean isTXTDL(ReportTypeEnum reportType) {
		return reportType == TXTDL;
	}

	static public boolean isVIEWTXT(ReportTypeEnum reportType) {
		return reportType == VIEWTXT;
	}
}
